#!/bin/sh
MYSELF=`which "$0" 2>/dev/null`
[ $? -gt 0 -a -f "$0" ] && MYSELF="./$0"
MYDIR=$(cd $(dirname $MYSELF) && pwd)
MYBASE=${MYSELF%.*}

if test -d "$MYDIR/java"; then
    export JAVA_HOME="$MYDIR/java"
fi

#export JAVA_HOME

java=java
if test -n "$JAVA_HOME"; then
    java="$JAVA_HOME/bin/java"
fi

LOPTS=" "

export LUAY_HOME="$MYDIR/lib/luay"
export LUAY_LIB="$(cd $MYDIR/.. && pwd)/lib/luay"

if [ -f "$MYBASE.jar" ]; then
  exec "$java" $_JAVA_ARGS -splash:$MYDIR/te-splash.png -jar "$MYBASE.jar" ${LOPTS} "$@"
else
  exec "$java" $_JAVA_ARGS -splash:$MYDIR/te-splash.png -jar "$MYSELF" ${LOPTS} "$@"
fi

exit 1
